/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.mobile;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VolumeControl;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.recompile.mobile.Mobile;

public class PlatformPlayer
implements Player {
    private String contentType = "";
    private audioplayer player;
    private int state = 100;
    private Vector<PlayerListener> listeners = new Vector();
    private Control[] controls = new Control[3];

    public PlatformPlayer(InputStream stream, String type) {
        this.contentType = type;
        if (type.equals("audio/midi") || type.equals("sp-midi") || type.equals("audio/spmidi")) {
            this.player = new midiPlayer(stream);
        } else if (type.equals("audio/x-wav")) {
            this.player = new wavPlayer(stream);
        } else {
            System.out.println("No Player For: " + this.contentType);
            this.player = new audioplayer();
        }
        this.controls[0] = new volumeControl();
        this.controls[1] = new tempoControl();
        this.controls[2] = new midiControl();
    }

    public PlatformPlayer(String locator) {
        System.out.println("Player locator: " + locator);
    }

    @Override
    public void close() {
        try {
            this.player.stop();
            this.state = 0;
            this.notifyListeners("closed", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state = 0;
    }

    @Override
    public int getState() {
        if (!this.player.isRunning()) {
            this.state = 300;
        }
        return this.state;
    }

    @Override
    public void start() {
        if (Mobile.getPlatform().sound) {
            try {
                this.player.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.player.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addPlayerListener(PlayerListener playerListener) {
        this.listeners.add(playerListener);
    }

    @Override
    public void removePlayerListener(PlayerListener playerListener) {
        this.listeners.remove(playerListener);
    }

    private void notifyListeners(String event, Object eventData) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).playerUpdate(this, event, eventData);
        }
    }

    @Override
    public void deallocate() {
        this.stop();
        if (this.player instanceof midiPlayer) {
            ((midiPlayer)this.player).midi.close();
        }
        this.player = null;
        this.state = 0;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public long getMediaTime() {
        return this.player.getMediaTime();
    }

    @Override
    public void prefetch() {
        this.state = 300;
    }

    @Override
    public void realize() {
        this.state = 200;
    }

    @Override
    public void setLoopCount(int count) {
        this.player.setLoopCount(count);
    }

    @Override
    public long setMediaTime(long now) {
        return this.player.setMediaTime(now);
    }

    @Override
    public Control getControl(String controlType) {
        if (controlType.equals("VolumeControl")) {
            return this.controls[0];
        }
        if (controlType.equals("TempoControl")) {
            return this.controls[1];
        }
        if (controlType.equals("MIDIControl")) {
            return this.controls[2];
        }
        if (controlType.equals("javax.microedition.media.control.VolumeControl")) {
            return this.controls[0];
        }
        if (controlType.equals("javax.microedition.media.control.TempoControl")) {
            return this.controls[1];
        }
        if (controlType.equals("javax.microedition.media.control.MIDIControl")) {
            return this.controls[2];
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return this.controls;
    }

    private class tempoControl
    implements TempoControl {
        int tempo = 5000;
        int rate = 5000;

        private tempoControl() {
        }

        @Override
        public int getTempo() {
            return this.tempo;
        }

        @Override
        public int setTempo(int millitempo) {
            this.tempo = millitempo;
            return this.tempo;
        }

        @Override
        public int getMaxRate() {
            return this.rate;
        }

        @Override
        public int getMinRate() {
            return this.rate;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public int setRate(int millirate) {
            this.rate = millirate;
            return this.rate;
        }
    }

    private class volumeControl
    implements VolumeControl {
        private int level = 100;
        private boolean muted = false;

        private volumeControl() {
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public boolean isMuted() {
            return this.muted;
        }

        @Override
        public int setLevel(int value) {
            this.level = value;
            return this.level;
        }

        @Override
        public void setMute(boolean mute) {
            this.muted = mute;
        }
    }

    private class midiControl
    implements MIDIControl {
        private midiControl() {
        }

        @Override
        public int[] getBankList(boolean custom) {
            return new int[0];
        }

        @Override
        public int getChannelVolume(int channel) {
            return 0;
        }

        @Override
        public String getKeyName(int bank, int prog, int key) {
            return "";
        }

        @Override
        public int[] getProgram(int channel) {
            return new int[0];
        }

        @Override
        public int[] getProgramList(int bank) {
            return new int[0];
        }

        @Override
        public String getProgramName(int bank, int prog) {
            return "";
        }

        @Override
        public boolean isBankQuerySupported() {
            return false;
        }

        @Override
        public int longMidiEvent(byte[] data, int offset, int length) {
            return 0;
        }

        @Override
        public void setChannelVolume(int channel, int volume) {
        }

        @Override
        public void setProgram(int channel, int bank, int program) {
        }

        @Override
        public void shortMidiEvent(int type, int data1, int data2) {
        }
    }

    private class wavPlayer
    extends audioplayer {
        private AudioInputStream wavStream;
        private Clip wavClip;
        private int loops;
        private Long time;

        public wavPlayer(InputStream stream) {
            this.loops = 0;
            this.time = new Long(0L);
            try {
                this.wavStream = AudioSystem.getAudioInputStream(stream);
                this.wavClip = AudioSystem.getClip();
                this.wavClip.open(this.wavStream);
                PlatformPlayer.this.state = 300;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void start() {
            if (this.isRunning()) {
                this.wavClip.setFramePosition(0);
            }
            this.time = this.wavClip.getMicrosecondPosition();
            this.wavClip.start();
            PlatformPlayer.this.state = 400;
            PlatformPlayer.this.notifyListeners("started", this.time);
        }

        @Override
        public void stop() {
            this.wavClip.stop();
            this.time = this.wavClip.getMicrosecondPosition();
            PlatformPlayer.this.state = 300;
            PlatformPlayer.this.notifyListeners("stopped", this.time);
        }

        @Override
        public void setLoopCount(int count) {
            this.loops = count;
            this.wavClip.loop(count);
        }

        @Override
        public long setMediaTime(long now) {
            this.wavClip.setMicrosecondPosition(now);
            return now;
        }

        @Override
        public long getMediaTime() {
            return this.wavClip.getMicrosecondPosition();
        }

        @Override
        public boolean isRunning() {
            return this.wavClip.isRunning();
        }
    }

    private class midiPlayer
    extends audioplayer {
        private Sequencer midi;
        private int loops;

        public midiPlayer(InputStream stream) {
            this.loops = 0;
            try {
                this.midi = MidiSystem.getSequencer();
                this.midi.open();
                this.midi.setSequence(stream);
                PlatformPlayer.this.state = 300;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void start() {
            this.midi.start();
            PlatformPlayer.this.state = 400;
            PlatformPlayer.this.notifyListeners("started", new Long(0L));
        }

        @Override
        public void stop() {
            this.midi.stop();
            PlatformPlayer.this.state = 200;
        }

        @Override
        public void setLoopCount(int count) {
            this.loops = count;
            this.midi.setLoopCount(count);
        }

        @Override
        public long setMediaTime(long now) {
            try {
                this.midi.setTickPosition(now);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return now;
        }

        @Override
        public long getMediaTime() {
            return 0L;
        }

        @Override
        public boolean isRunning() {
            return this.midi.isRunning();
        }
    }

    private class audioplayer {
        private audioplayer() {
        }

        public void start() {
        }

        public void stop() {
        }

        public void setLoopCount(int count) {
        }

        public long setMediaTime(long now) {
            return now;
        }

        public long getMediaTime() {
            return 0L;
        }

        public boolean isRunning() {
            return false;
        }
    }
}

